<?php
class Vote extends AppModel {
	public $belongsTo = array('Article', 'User');
	public $validate = array(
		'article_id' => array('required' => true, 'rule' => 'notEmpty'),
		'user_id' => array('required' => true, 'rule' => 'notEmpty'),
		'vote' => array(
			'required' => array('required' => true, 'rule' => 'notEmpty'),
			'range' => array(
				'rule' => array('range', 0, 6),
				'allowEmpty' => true
			)
		)
	);
}
?>