<?php
class ArticlesController extends AppController {
	public function index() {
		$this->paginate['limit'] = 2;
		$articles = $this->paginate();
		$this->set(compact('articles'));
	}
	public function add() {
		if (!empty($this->data)) {
			$this->Article->create();
			if ($this->Article->save($this->data)) {
				$this->Session->setFlash(
					sprintf(__('Article "%s" saved', true), $this->Article->field('title'))
				);
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash('Please correct the errors');
			}
		}
	}
	public function view($id) {
		$article = $this->Article->find('first', array(
			'conditions' => array('Article.id' => $id)
		));
		if (empty($article)) {
			$this->cakeError('error404');
		}
		$this->set(compact('article'));
	}
}
?>