<?php
class ArticlesController extends AppController {
	public function view($id) {
		$article = $this->Article->find('first', array(
			'conditions' => array('Article.id' => $id)
		));
		if (empty($article)) {
			$this->cakeError('error404');
		}

		$limit = !empty($this->params['url']['related']) ?
			$this->params['url']['related'] :
			0;
		$articles = $this->Article->find('all', array(
			'conditions' => array(
				'Category.id' => $article['Category']['id'],
				'Article.id !=' => $article['Article']['id']
			),
			'order' => 'RAND()',
			'limit' => $limit > 0 ? $limit : null
		));
		$this->set(compact('article', 'articles', 'limit'));

		$slug = !empty($this->params['named']['title']) ?
			$this->params['named']['title'] :
			null;
		$categorySlug = !empty($this->params['named']['category']) ?
			$this->params['named']['category'] :
			null;

		$this->set(compact('slug', 'categorySlug'));
	}
}
?>