<?php
App::import('Core', 'Router');

class ProfileRoute extends CakeRoute {
	public function match($url) {
		if (!empty($url['userName']) && $this->_exists($url['userName'])) {
			return parent::match($url);
		}
		return false;
	}

	public function parse($url) {
		$params = parent::parse($url);
		if (!empty($params) && $this->_exists($params['userName'])) {
			return $params;
		}
		return false;
	}

	protected function _exists($userName) {
		$userNames = Cache::read('usernames');
		if (empty($userNames)) {
			$profiles = ClassRegistry::init('Profile')->find('all', array(
				'fields' => array('username'),
				'recursive' => -1
			));
			if (!empty($profiles)) {
				$userNames = array_map(
					'strtolower',
					Set::extract('/Profile/username', $profiles)
				);
				Cache::write('usernames', $userNames);
			}
		}
		return in_array($userName, (array) $userNames);
	}
}
?>