<?php
class Post extends AppModel {
	public $belongsTo = array('Blog');
	public $_findMethods = array('search' => true);

	protected function _findSearch($state, $query, $results = array()) {
		if ($state == 'before') {
			if (!empty($query['terms'])) {
				$fields = array('title', 'body');
				$conditions = array();
				foreach ((array) $query['terms'] as $term) {
					foreach ($fields as $field) {
						$model = $this->alias;
						if (strpos($field, '.') !== false) {
							list($model, $field) = explode('.', $field);
						}
						$conditions[] = array(
							$model . '.' . $field . ' LIKE ?' => '%'.$term.'%'
						);
					}
				}

				if (empty($query['fields'])) {
					$query['fields'] = array('Post.title', 'Post.body');
				}

				if (!empty($query['operation']) && $query['operation'] == 'count') {
					$query['fields'] = 'COUNT(*) AS total';
				}

				$query['conditions'][] = array('or' => $conditions);
			}
			return array_diff_key($query, array('terms'=>null));
		} elseif (
				$state == 'after' && !empty($query['operation']) &&
				$query['operation'] == 'count'
		) {
			return (!empty($results[0][0]['total']) ? $results[0][0]['total'] : 0);
		}

		return $results;
	}
}
?>