<?php
class Article extends AppModel {
	public $validate = array(
		'title' => array(
			'required' => 'notEmpty'
		),
		'body' => array(
			'required' => 'notEmpty'
		)
	);

	public function __construct($id = false, $table = null, $ds = null) {
		foreach($this->validate as $field => $rules) {
			if (!is_array($rules)) {
				$rules = (array) $rules;
			}
			foreach($rules as $key => $rule) {
				if (!is_array($rule)) {
					$rules[$key] = compact('rule');
				}
			}
			$this->validate[$field] = $rules;
		}

		$this->validate = Set::merge($this->validate, array(
			'title' => array(
				'required' => array('message' => __('A title must be specified', true))
			),
			'body' => array(
				'required' => array('message' => __('You must define the body', true))
			)
		));

        parent::__construct($id, $table, $ds);
	}
}
?>
