<?php
App::import('Core', 'Security');
class UserShell extends Shell {
   public $uses = array('User');
   public function add() {
      $user = $this->in('Wprowadz nazwe uzytkownika (ENTER, aby przerwac):');
      if (empty($user)) {
         $this->_stop();
      }
      $defaultPassword = $this->_randomPassword();;
      $password = $this->in('Wprowadz haslo (ENTER, aby wygenerowac):', null, $defaultPassword);
      $this->out();
      $this->out('UZYTKOWNIK: '.$user);
      $this->out('HASLO: '.$password);
      $this->out();
      if (strtoupper($this->in('Wykonac?', array('Y', 'N'), 'N')) != 
'Y') {
         $this->_stop();
      }
      $user = array('User' => array(
         'username' => $user,
         'password' => Security::hash($password, null, true)
      ));
      $this->User->create();
      if ($this->User->save($user)) {
         $this->out('Utworzono uzytkownika.');
      } else {
         $this->error('Wystapil blad w trakcie tworzenia uzytkownika.');
      }
   }
   public function import() {
   $this->_checkArgs(1);
   $defaults = array(
      'limit' => null,
      'size' => 10,
      'verbose' => false
   );
   $options = array_merge(
      $defaults,
      array_intersect_key($this->params, $defaults)
   );
   $path = $this->args[0];
   if (!is_file($path) || !is_readable($path)) {
      $this->error('Nie mozna odczytac pliku '.$path);
   }
   $users = array();
   foreach($this->_parseCSV($path) as $i => $row) {
      $users[$row[0]] = $this->_randomPassword($options['size']);
      if (!empty($options['limit']) && $i + 1 == $options['limit']) {
         break;
      }
   }
   if ($options['verbose']) {
      $this->out('Liczba kont do utworzenia: '.number_format(count($users)));
   }
   foreach($users as $userName => $password) {
      if ($options['verbose']) {
         $this->out('Tworzenie uzytkownika '.$userName.'... ', false);
      }
      $user = array('User' => array(
         'username' => $userName,
         'password' => Security::hash($password, null, true)
      ));
      $this->User->create();
      $saved = ($this->User->save($user) !== false);
      if (!$saved) {
         unset($users[$userName]);
      }
      if ($options['verbose']) {
         $this->out($saved ? 'SUKCES' : 'BLAD');
      }
   }
   $this->out('Utworzono nastepujace konta:');
   foreach($users as $userName => $password) {
      $this->out($userName.' : '.$password);
   }
}

   public function help() {
   $this->out('Sposob uzycia: $ cake '.$this->shell.' <import <sciezka/do/pliku> [-limit N | -size N | -verbose] | add>');
   $this->out('gdzie:');
   $this->out();
   $this->out('-limit N: importuj maksymalnie N rekordow');
   $this->out('-size N: rozmiar generowanego hasla');
   $this->out('-verbose: wyswietlaj efekt dzialania programu');
}
protected function _parseCSV($path) {
   $file = fopen($path, 'r');
   if (!is_resource($file)) {
      $this->error('Nie moge otworzyc pliku '.$file);
   }
   $rows = array();
   while($row = fgetcsv($file)) {
      $rows[] = $row;
   }
   fclose($file);
   return $rows;
}

   protected function _randomPassword($size=10) {
      $chars = '@!#$_';
      foreach(array('A'=>'Z', 'a'=>'z', '0'=>'9') as $start => $end) {
         for ($i=ord($start), $limiti=ord($end); $i <= $limiti; $i++) 
         {
            $chars .= chr($i);
         }
      }
      $totalChars = strlen($chars);
      $password = '';
      for($i=0; $i < $size; $i++) {
         $password .= $chars[rand(0, $totalChars-1)];
      }
      return $password;
   }
}
?>
