<?php
App::import('Core', 'HttpSocket');
class ConsumeShell extends Shell {
    protected static $baseUrl;
    protected static $httpSocket;
    public function main() {
        if (empty($this->args) || count($this->args) != 1) {
            $this->err('Sposób użycia: cake consume <baseUrl>');
            $this->_stop();
        }	
        self::$baseUrl = $this->args[0]; 
        $this->test();
    }
    protected function test() {
        $this->request('/posts/add.json', 'POST', array(
            'title' => 'Nowy wpis',
            'body' => 'Treść nowego wpisu'
        ));
        $lastId = $this->listPosts();
        $this->hr();
        $this->request('/posts/edit/'.$lastId.'.json', 'POST', array(
            'title' => 'Nowy tytul wpisu',
            'body' => 'Nowa treść dla nowego wpisu'
        ));
        $this->listPosts();
        $this->hr();
        $this->request('/posts/delete/'.$lastId.'.json', 'DELETE');
        $this->listPosts();
    }
    protected function request($url, $method='GET', $data=null) {
        if (!isset(self::$httpSocket)) {
            self::$httpSocket = new HttpSocket();
        } else {
            self::$httpSocket->reset();
        }
        $body = self::$httpSocket->request(array(
            'method' => $method,
            'uri' => self::$baseUrl . '/' . $url,
            'body' => $data
        ));
        if ($body === false || self::$httpSocket->response['status']['code'] != 200) {
            $error = 'Błąd podczas wykonywania operacji '.$method.' pod adresem '.$url;
            if ($body !== false) {
                $error = '[' . self::$httpSocket->response['status']['code'] . '] ' . $error;
            }
            $this->err($error);
            $this->_stop();
        }
        return $body;
    }
    protected function listPosts() {
        $response = json_decode($this->request('/posts.json'));
        $lastId = null;
        foreach($response as $item) {
            $lastId = $item->Post->id;
            $this->out($item->Post->title . ': ' . $item->Post->url);
        }
        return $lastId;
    }
}
?>
