<?php
class QueryLogComponent extends Object {
	public $minimumTime = 10;
	public $explain = 'EXPLAIN %s';
	
	public function initialize($controller, $settings = array()) {
		$this->_set($settings);
		if (!is_bool($this->enabled)) {
			$this->enabled = Configure::read('debug') >= 2;
		}
	}

	public function beforeRender($controller) {
		if ($this->enabled) {
			$queryLog = array();
			$datasources = ConnectionManager::sourceList();
			foreach($datasources as $name) {
				$datasource = ConnectionManager::getDataSource($name);
				if ($datasource->isInterfaceSupported('getLog')) {
					$log = $datasource->getLog();
					foreach($log['log'] as $i => $line) {
						if (
							empty($line['error']) &&
							$line['took'] >= $this->minimumTime &&
							stripos(trim($line['query']), 'SELECT') === 0
						) {
							$explain = $datasource->query(sprintf(
								$this->explain,
								$line['query']
							));
							if (!empty($explain)) {
								foreach($explain as $j => $explainLine) {
									$explain[$j] = array_combine(
										array_map('strtolower', array_keys($explainLine[0])),
										$explainLine[0]
									);
								}
								$log['log'][$i]['explain'] = $explain;
							}
						}
					}
					if (!empty($log['log'])) {
						$queryLog[$name] = $log;
					}
				}
			}

			if (!empty($queryLog)) {
				$controller->set(compact('queryLog'));
			}
		}
	}
}
?>