<?php
App::import('Component', 'Email');
class EmailShell extends Shell {
	public $uses = array('Newsletter', 'Subscriber');

	public function startup() {
        $this->Email = new EmailComponent();
		$this->Email->delivery = 'smtp';
		$this->Email->smtpOptions = array(
			'host' => 'smtp.email.com',
			'username' => 'smtpUser',
			'password' => 'smtpPassword'
		);
	}

	public function main() {
		$email = !empty($this->params['to']) ? $this->params['to'] : array();

		$newsletter = $this->Newsletter->find('first', array(
			'conditions' => array('sent' => false),
			'recursive' => -1
		));
		if (empty($newsletter)) {
			$this->out('All newsletters have been sent');
			$this->_stop();
		}

		$this->out('Sending newsletter "'.$newsletter['Newsletter']['title'].'"');

		$subscribers = $this->Subscriber->find('all');
		foreach($subscribers as $subscriber) {
			$this->out('Sending to '.$subscriber['Subscriber']['email'].'... ', false);

			$currentEmail = !empty($email) ? $email : $subscriber['Subscriber']['email'];
			if (!empty($email)) {
				$this->Email->headers['Destination'] = $subscriber['Subscriber']['email'];
			}

			$this->Email->sendAs = 'html';
			$this->Email->subject = $newsletter['Newsletter']['title'];
			$this->Email->from = 'My Application <info@email.com>';
			$this->Email->to = $subscriber['Subscriber']['name'] . ' <'.$currentEmail.'>';

            $sent = $this->Email->send($newsletter['Newsletter']['body']);
			if ($sent) {
				$this->out('DONE');
			} else {
				$error = !empty($this->Email->smtpError) ? $this->Email->smtpError : '';
				$this->out('ERROR' . (!empty($error) ? ': '.$error : ''));
			}

            $this->Newsletter->NewslettersSubscriber->create(array(
                'newsletter_id' => $newsletter['Newsletter']['id'],
                'subscriber_id' => $subscriber['Subscriber']['id'],
                'sent' => $sent
            ));
            $this->Newsletter->NewslettersSubscriber->save();

			$this->Email->reset();
		}

		$this->Newsletter->id = $newsletter['Newsletter']['id'];
		$this->Newsletter->saveField('sent', true);
	}
}
?>
