<?php
App::import('Core', 'HttpSocket');
class ConsumeShell extends Shell {
    protected static $baseUrl;
    protected static $httpSocket;
    protected static $user;
    protected static $password;

    public function main() {
        if (empty($this->args) || count($this->args) != 3) {
            $this->err('USAGE: cake consume <baseUrl> <user> <password>');
            $this->_stop();
        }

        list(self::$baseUrl, self::$user, self::$password) = $this->args;

        $this->test();
    }

    protected function test() {
        $this->request('/posts/add.json', 'POST', array(
            'title' => 'New Post',
            'body' => 'Body for my new post'
        ));

        $lastId = $this->listPosts();
        $this->hr();

        $this->request('/posts/edit/'.$lastId.'.json', 'POST', array(
            'title' => 'New Post Title',
            'body' => 'New body for my new post'
        ));

        $this->listPosts();
        $this->hr();

        $this->request('/posts/delete/'.$lastId.'.json', 'DELETE');

        $this->listPosts();
    }

    protected function request($url, $method='GET', $data=null) {
        if (!isset(self::$httpSocket)) {
            self::$httpSocket = new HttpSocket();
        } else {
            self::$httpSocket->reset();
        }

        $body = self::$httpSocket->request(array(
            'method' => $method,
            'uri' => self::$baseUrl . '/' . $url,
            'body' => $data,
            'auth' => array(
                'user' => self::$user,
                'pass' => self::$password
            )
        ));

        if ($body === false || self::$httpSocket->response['status']['code'] != 200) {
            $error = 'ERROR while performing '.$method.' to '.$url;
            if ($body !== false) {
                $error = '[' . self::$httpSocket->response['status']['code'] . '] ' . $error;
            }
            $this->err($error);
            $this->_stop();
        }

        return $body;
    }

    protected function listPosts() {
        $response = json_decode($this->request('/posts.json'));
        $lastId = null;
        foreach($response as $item) {
            $lastId = $item->Post->id;
            $this->out($item->Post->title . ': ' . $item->Post->url);
        }
        return $lastId;
    }
}
?>
