<?php
class PostsController extends AppController {
	public function index() {
		/*
		$data = $this->Post->find('first', array(
			'contain' => array(
				'Blog' => array(
					'fields' => array('name'),
					'User' => array('fields' => array('name'))
				)
			)
		));
		*/

		$data = $this->Post->find('first', array(
			'fields' => array(
				'Post.id',
				'Post.title',
				'Blog.name',
				'User.name'
			),
			'joins' => array(
				array(
					'type' => 'inner',
					'alias' => 'Blog',
					'table' => $this->Post->Blog->table,
					'conditions' => array(
						'Blog.id = Post.blog_id'
					)
				),
				array(
					'type' => 'inner',
					'alias' => 'User',
					'table' => $this->Post->Blog->User->table,
					'conditions' => array(
						'User.id = Blog.user_id'
					)
				)
			),
			'recursive' => -1
		));

		$this->set(compact('data'));
	}
}
?>