//                              Program Turbo C++

#include <iostream.h>
#include <graphics.h>
#include <math.h>

class RecursiveCurve {
public:
    RecursiveCurve();
    void readInitValues();
    void snowflake();
    void cross();
private:
    double side, angle;
    int level;
    void right(double x) {
        angle += x;
    }
    void left (double x) {
        angle -= x;
    }
    void drawFourLines(double side, int level);
    void drawCrossSide(double side, int level);
};

void RecursiveCurve::RecursiveCurve() {
    setcolor(WHITE);
    setbkcolor(BLUE);
    moveto (200,150);
    angle = 0.0;
    cout << "Podaj bok (side) i poziom (level): ";
    cin  >> side >> level;
}

void RecursiveCurve::drawFourLines(double side, int level) {
    if (level == 0)                           // parametry sin() i cos()
         linerel((cos(angle*M_PI/180)*side),  // to kty w radianach, czyli
                 (sin(angle*M_PI/180)*side)); // wymagany jest wspczynnik
    else {                                    // M_PI/180
         drawFourLines(side/3.0,level-1);
         left (60);
         drawFourLines(side/3.0,level-1);
         right(120);
         drawFourLines(side/3.0,level-1);
         left (60);
         drawFourLines(side/3.0,level-1);
    }
}

void RecursiveCurve::snowflake() {
    for (int i = 1; i <= 3; i++) {
        drawFourLines(side,level);
        right(120);
    }
}

void main() {
    int grBoard = DETECT, grMode, grResult, grError;
    initgraph(&grBoard,&grMode,"c:\\tc\\bgi");
    grError = graphresult();
    if (grError != grOk) {
        cerr << "bd: " << grapherrormsg(grError) << endl;
        return;
    }
    RecursiveCurve().snowflake();
}
