#include <iostream>
#include <string>
#include <list>

using namespace std;

class Person;        // deklaracja wyprzedzajca

class Book {
public:
    Book() { 
        person = 0; 
    }
    bool operator== (const Book& bk) const {
        return strcmp(title,bk.title) == 0; 
    }
private:
    char *title;
    Person *person;
    friend ostream& operator<< (ostream&,const Person&);
    friend class CheckedOutBook;
    friend void includeBook();
    friend void checkOutBook();
    friend void returnBook();
	ostream& printBook(ostream& out) const;
	friend ostream& operator<< (ostream& out, const Book& bk) {
        return bk.printBook(out);
	}
};

class Author {
public:
    Author() {
    }
    bool operator== (const Author& ar) const {
        return strcmp(name,ar.name) == 0; 
    }
private:
    char *name;
    list<Book*> books;
    friend ostream& operator<< (ostream&,const Person&);
    friend class CheckedOutBook;
    friend void includeBook();
    friend void checkOutBook();
    friend void returnBook();
    friend ostream& operator<< (ostream& out, const Author& ar) {
        out << ar.name << endl;
        for (list<Book*>::const_iterator ref = ar.books.begin(); ref != ar.books.end(); ref++)
            out << **ref; // przeciony operator <<
        return out;
    }
};

class CheckedOutBook {
public:
    CheckedOutBook(Author *ar = 0, Book *bk = 0) {
        author = ar; book = bk;
    }
    bool operator== (const CheckedOutBook& bk) const {
        return strcmp(author->name,bk.author->name) == 0 &&
               strcmp(book->title,bk.book->title) == 0;
    }
    bool operator!= (const CheckedOutBook& bk) const {
        return !(*this == bk);
    }
    bool operator< (const CheckedOutBook& bk) const {
        if (strcmp(author->name,bk.author->name) == 0)
            return strcmp(book->title,bk.book->title) < 0;
        return strcmp(author->name,bk.author->name) < 0;
    }
    bool operator> (const CheckedOutBook& bk) const {
          return !(*this == bk) && !(*this < bk);
    }
private:
    Author* author;
    Book* book;
    friend ostream& operator<< (ostream&,const Person&);
    friend void checkOutBook();
    friend void returnBook();
};

class Person {
public:
    Person() {
    }
    bool operator== (const Person& pn) const {
        return strcmp(name,pn.name) == 0; 
    }
private:
    char *name;
    list<CheckedOutBook> books;
    friend void checkOutBook();
    friend void returnBook();
	friend Book;
    friend ostream& operator<< (ostream& out, const Person& pr) {
        out << pr.name;
        if (!pr.books.empty()) {
            out << " ma nastpujce ksiki:\n";
            list<CheckedOutBook>::const_iterator bk = pr.books.begin();
            for ( ; bk != pr.books.end(); bk++)
                out << "    * " << bk->author->name << ", " 
                    << bk->book->title << endl;
        }
        else out << " nie ma adnych ksiek\n";
        return out;
    }
};

ostream& Book::printBook(ostream& out) const {
    out << "    * " << title;
    if (person != 0)
        out << " - ksik wypoyczy/a " << person->name; // przeciony <<
    out << endl;
    return out;
}

list<Author*> catalog['Z'+1];
list<Person*> people['Z'+1];

template<class T>
ostream& operator<< (ostream& out, const list<T>& lst) {
    for (list<T>::const_iterator ref = lst.begin(); ref != lst.end(); ref++)
        out << **ref; // przeciony <<
    return out;
}

template<class T1, class T2>
list<T2>::iterator findIt(list<T2>& lst, const T1& el) {
    list<T2>::iterator ref = lst.begin();
    for ( ; ref != lst.end(); ref++)
        if (**ref == el) // przeciony ==
            break;
    return ref;
}

char* getString(char *msg) {   
    char s[82], i, *destin;
    cout << msg;
    cin.get(s,80);
    while (cin.get(s[81]) && s[81] != '\n');  // odrzucenie nadmiarowych
    destin = new char[strlen(s)+1];           // znakw
    for (i = 0; destin[i] = toupper(s[i]); i++);
    return destin;
}

void status() {   
    register int i;
    cout << "W bibliotece s nastpujce ksiki:\n\n";
    for (i = 'A'; i <= 'Z'; i++)
        if (!catalog[i].empty())
            cout << catalog[i];
    cout << "\nDo biblioteki zapisani s nastpujcy czytelnicy:\n\n"; 
    for (i = 'A'; i <= 'Z'; i++)
        if (!people[i].empty())
            cout << people[i];
}

void includeBook() {   
    Author *newAuthor = new Author;
    Book *newBook = new Book;
    newAuthor->name = getString("Podaj autora: ");
    newBook->title  = getString("Podaj tytu ksiki: ");
    list<Author*>::iterator oldAuthor = findIt(catalog[newAuthor->name[0]],*newAuthor);
    if (oldAuthor == catalog[newAuthor->name[0]].end()) {
         newAuthor->books.push_front(newBook);
         catalog[newAuthor->name[0]].push_front(newAuthor);
    }
    else (*oldAuthor)->books.push_front(newBook);
}

void checkOutBook() {
    Person *person = new Person;
    Author author;
    Book book;
    list<Author*>::iterator authorRef;
    list<Book*>::iterator bookRef;
    person->name = getString("Podaj imi i nazwisko: ");
    while (true) { 
        author.name = getString("Podaj autora: ");
        authorRef = findIt(catalog[author.name[0]],author);
        if (authorRef == catalog[author.name[0]].end())
             cout << "Bdnie podano autora\n";
        else break;
    }
    while (true) { 
        book.title = getString("Podaj tytu ksiki: ");
          bookRef = findIt((*authorRef)->books,book);
        if (bookRef == (*authorRef)->books.end())
             cout << "Bdny tytu\n";
        else break;
    }
    list<Person*>::iterator personRef;
    personRef = findIt(people[person->name[0]],*person);
    CheckedOutBook checkedOutBook(*authorRef,*bookRef);
    if (personRef == people[person->name[0]].end()) { // nowy czytelnik
         person->books.push_front(checkedOutBook);
         people[person->name[0]].push_front(person);
         (*bookRef)->person = *people[person->name[0]].begin();
    }
    else {
         (*personRef)->books.push_front(checkedOutBook);
         (*bookRef)->person = *personRef;
    }
}

void returnBook() {
    Person person;
    Book book;
    Author author;
    list<Person*>::iterator personRef;
    list<Book*>::iterator bookRef;
    list<Author*>::iterator authorRef;
    while (true) { 
        person.name = getString("Podaj imi i nazwisko: ");
        personRef = findIt(people[person.name[0]],person);
        if (personRef == people[person.name[0]].end())
             cout << "Bdnie podano nazwisko\n";
        else break;
    }
    while (true) { 
        author.name = getString("Podaj autora: ");
        authorRef = findIt(catalog[author.name[0]],author);
        if (authorRef == catalog[author.name[0]].end())
             cout << "Bdnie podano autora\n";
        else break;
    }
    while (true) {
        book.title = getString("Podaj tytu ksiki: ");
        bookRef = findIt((*authorRef)->books,book);
        if (bookRef == (*authorRef)->books.end())
             cout << "Bdnie podano tytu\n";
        else break;
    }
    CheckedOutBook checkedOutBook(*authorRef,*bookRef);
    (*bookRef)->person = 0;
    (*personRef)->books.remove(checkedOutBook);
}

int menu() {
    int option;
    cout << "\nPodaj jedn z nastpujcych opcji:\n"
         << "1. Dodaj ksik do katalogu\n2. Wypoycz ksik\n"
         << "3. Zwrot ksiki\n4. Stan\n5. Koniec\n"
         << "Co wybierasz? ";
    cin >> option;
    cin.get();         // odrzu '\n';
    return option;
}

int main() {
    while (true)
        switch (menu()) {
            case 1: includeBook();  break;
            case 2: checkOutBook(); break;
            case 3: returnBook();   break;
            case 4: status();       break;
            case 5: return 0;
            default: cout << "Podano niewaciw opcj, sprbuj jeszcze raz: ";
        }
    return 0;
}
