//************************  intSLLst.cpp  **************************

#include <iostream.h>
#include "intSLLst.h"

IntSLList::~IntSLList() {
    for (IntNode *p; !isEmpty(); ) {
        p = head->next;
        delete head;
        head = p;
    }
}

void IntSLList::addToHead(int el) {
    head = new IntNode(el,head);
    if (tail == 0)
       tail = head;
}

void IntSLList::addToTail(int el) {
    if (tail != 0) {         // jeli lista nie jest pusta
         tail->next = new IntNode(el);
         tail = tail->next;
    }
    else head = tail = new IntNode(el);
}

int IntSLList::deleteFromHead() {
    int el = head->info;
    IntNode *tmp = head;
    if (head == tail)   // jeli lista zawiera jeden wze
         head = tail = 0;
    else head = head->next;
    delete tmp;
    return el;
}

int IntSLList::deleteFromTail() {
    int el = tail->info;
    if (head == tail) { // jeli lista zawiera jeden wze
         delete head;
         head = tail = 0;
    }
    else {              // jeli lista zawiera ponad jeden wze
         IntNode *tmp;  // znajd poprzednik elementu ostatniego
         for (tmp = head; tmp->next != tail; tmp = tmp->next);
         delete tail;
         tail = tmp;    // przedostatni staje si ostatnim
         tail->next = 0;
    }
    return el;
}

void IntSLList::deleteNode(int el) {
    if (head != 0)                     // jeli lista niepusta
         if (head == tail && el == head->info) { // jeli lista zawiera
              delete head;                       // tylko jeden element
              head = tail = 0;
         }
         else if (el == head->info) {  // jeli lista zawiera ponad jeden wze
              IntNode *tmp = head;
              head = head->next;
              delete tmp;              // usunicie dotychczasowego pocztku
         }
         else {                        // jeli wicej ni jeden wze na licie
              IntNode *pred, *tmp;
              for (pred = head, tmp = head->next; // usuwany jest wze inny
                   tmp != 0 && !(tmp->info == el);// ni pierwszy
                   pred = pred->next, tmp = tmp->next);
              if (tmp != 0) {
                   pred->next = tmp->next;
                   if (tmp == tail)
                      tail = pred;
                   delete tmp;
              }
         }
}

bool IntSLList::isInList(int el) const {
    IntNode *tmp;
    for (tmp = head; tmp != 0 && !(tmp->info == el); tmp = tmp->next);
    return tmp != 0;
}

void IntSLList::printAll() const {
    for (IntNode *tmp = head; tmp != 0; tmp = tmp->next)
        cout << tmp->info << " ";
}
