//************************  genBST.h  **************************
//                 oglne binarne drzewo poszukiwania

#include <queue>
#include <stack>

using namespace std;

#ifndef BINARY_SEARCH_TREE
#define BINARY_SEARCH_TREE

template<class T>
class Stack : public stack<T> {
public:
    T pop() {
        T tmp = top();
        stack<T>::pop();
        return tmp;
    }
};

template<class T>
class Queue : public queue<T> {
public:
    T dequeue() {
        T tmp = front();
        queue<T>::pop();
        return tmp;
    }
    void enqueue(const T& el) {
        push(el);
    }
};

template<class T>
class BSTNode {
public:
    BSTNode() { 
        left = right = 0; 
    }
    BSTNode(const T& el, BSTNode *l = 0, BSTNode *r = 0) {
        key = el; left = l; right = r; 
    }
    T key;
    BSTNode *left, *right;
};

template<class T>
class BST {
public:
    BST() { 
        root = 0; 
    }
    ~BST() { 
        clear();
    }
    void clear() {
        clear(root); root = 0;
    }
    bool isEmpty() const { 
        return root == 0; 
    }
    void preorder() { 
        preorder(root);   
    }
    void inorder() { 
        inorder(root); 
    }
    void postorder() { 
        postorder(root);  
    }
    void insert(const T&);
    T* search(const T& el) const { 
        return search(root,el);
    }
    void deleteByCopying(BSTNode<T>*&);
    void findAndDeleteByCopying(const T&);
    void deleteByMerging(BSTNode<T>*&);
    void findAndDeleteByMerging(const T&);
    void iterativePreorder();
    void iterativeInorder();
    void iterativePostorder();
    void breadthFirst();
    void MorrisPreorder();
    void MorrisInorder();
    void MorrisPostorder();
    void balance(T*,int,int);
protected:
    BSTNode<T>* root;
    void clear(BSTNode<T>*);
    T* search(BSTNode<T>*, const T&) const;
    void preorder(BSTNode<T>*);
    void inorder(BSTNode<T>*);
    void postorder(BSTNode<T>*);
    virtual void visit(BSTNode<T>* p) { 
        cout << p->key << ' '; 
    }
};

template<class T>
void BST<T>::clear(BSTNode<T> *p) {
    if (p != 0) {
         clear(p->left);
         clear(p->right);
         delete p;
     }
}

template<class T>
void BST<T>::insert(const T& el) {   
    BSTNode<T> *p = root, *prev = 0;
    while (p != 0) {        // znajd miejsce na nowy wze
        prev = p;
        if (p->key < el)
             p = p->right;
        else p = p->left;
    }
    if (root == 0)    // drzewo jest puste
         root = new BSTNode<T>(el);
    else if (prev->key < el)
         prev->right = new BSTNode<T>(el);
    else prev->left  = new BSTNode<T>(el);
}

template<class T>
T* BST<T>::search(BSTNode<T>* p, const T& el) const {
    while (p != 0)
        if (el == p->key)
             return &p->key;
        else if (el < p->key)
             p = p->left;
        else p = p->right;
    return 0;
}

template<class T>
void BST<T>::inorder(BSTNode<T> *p) {
     if (p != 0) {
         inorder(p->left);
         visit(p);
         inorder(p->right);
     }
}

template<class T>
void BST<T>::preorder(BSTNode<T> *p) {
    if (p != 0) {
        visit(p);
        preorder(p->left);
        preorder(p->right);
    }
}

template<class T>
void BST<T>::postorder(BSTNode<T>* p) {
    if (p != 0) {
        postorder(p->left);
        postorder(p->right);
        visit(p);
    }
}

template<class T>
void BST<T>::deleteByCopying(BSTNode<T>*& node) {    
    BSTNode<T> *previous, *tmp = node;
     if (node->right == 0)                  // wze nie ma prawego dziecka
          node = node->left;   
     else if (node->left == 0)              // wze nie ma lewego dziecka
          node = node->right;
     else {
          tmp = node->left;                 // wze ma oba wzy dzieci
          previous = node;                  // 1.
          while (tmp->right != 0) {         // 2.
              previous = tmp;
              tmp = tmp->right;
          }
          node->key = tmp->key;             // 3.
          if (previous == node)
               previous->left  = tmp->left;
          else previous->right = tmp->left; // 4.
     }
     delete tmp;                            // 5.
}

// findAndDeleteByCopying() przeszukuje drzewo w celu znalezienia wza
// zawierajcego el. Jeli takie wze zostanie znaleziony, wywoywana jest
// funkcja DeleteByCopying().

template<class T>
void BST<T>::findAndDeleteByCopying(const T& el) {    
    BSTNode<T> *p = root, *prev = 0;
     while (p != 0 && !(p->key == el)) {
         prev = p;
         if (p->key < el)
              p = p->right;
         else p = p->left;
     }
     if (p != 0 && p->key == el)
          if (p == root)
               deleteByCopying(root);
          else if (prev->left == p)
               deleteByCopying(prev->left);
          else deleteByCopying(prev->right);
     else if (root != 0)
          cout << "klucza " << el << " nie ma w drzewie\n";
     else cout << "drzewo jest puste\n";
}

template<class T>
void BST<T>::deleteByMerging(BSTNode<T>*& node) {   
    BSTNode<T> *tmp = node;
    if (node != 0) {
        if (!node->right)           // drzewo nie ma prawego dziecka; lewe,
             node = node->left;     // o ile istnieje, jest powizane z rodzicem
        else if (node->left == 0)   // drzewo nie ma lewego dziecka; prawe,
             node = node->right;    // o ile istnieje, jest powizane z rodzicem
        else {                      // czenie poddrzew gotowe
             tmp = node->left;      // 1. przejd w lewo
             while (tmp->right != 0)// 2. potem w prawo, do koca
                tmp = tmp->right;
             tmp->right =           // 3. ustal powizanie skrajnego wza
                node->right;        //    poddrzewa lewego oraz poddrzewa
                                    //    prawego
             tmp = node;            // 4.
             node = node->left;     // 5.
        }
        delete tmp;                 // 6.
     }
}

template<class T>
void BST<T>::findAndDeleteByMerging(const T& el) {    
    BSTNode<T> *node = root, *prev = 0;
    while (node != 0) {
        if (node->key == el)
             break;
        prev = node;
        if (node->key < el)
             node = node->right;
        else node = node->left;
    }
    if (node != 0 && node->key == el)
         if (node == root)
              deleteByMerging(root);
         else if (prev->left == node)
              deleteByMerging(prev->left);
         else deleteByMerging(prev->right);
    else if (root != 0)
         cout << "klucza " << el << " nie ma w drzewie\n";
    else cout << "drzewo jest puste\n";
}

template<class T>
void BST<T>::iterativePreorder() {    
    Stack<BSTNode<T>*> travStack;
    BSTNode<T> *p = root;
    if (p != 0) {
        travStack.push(p);
        while (!travStack.empty()) {
            p = travStack.pop();
            visit(p);
            if (p->right != 0)
                 travStack.push(p->right);
            if (p->left != 0)             // lewe dziecko przesunite za prawe,
                 travStack.push(p->left); // aby byo na szczycie stosu
        }
    }
}

template<class T>
void BST<T>::iterativeInorder() {    
    Stack<BSTNode<T>*> travStack;
    BSTNode<T> *p = root;
    while (p != 0) {
        while (p != 0) {                 // przy przechodzeniu w lewo umie
            if (p->right)                // na stosie prawe dziecko (o ile
               travStack.push(p->right); // istnieje) i sam wze
            travStack.push(p);
            p = p->left;
        }
        p = travStack.pop();             // zdejmij wze bez lewego dziecka
        while (!travStack.empty() && p->right == 0) { // odwied jego i wszystkie
            visit(p);                                 // wzy bez prawego dziecka
            p = travStack.pop();
        }
        visit(p);                        // odwied te pierwszy wze z prawym
        if (!travStack.empty())          // dzieckiem
             p = travStack.pop();
        else p = 0;
    }
}

template<class T>
void BST<T>::iterativePostorder() {    
    Stack<BSTNode<T>*> travStack;
    BSTNode<T>* p = root, *q = root;
    while (p != 0) {
        for ( ; p->left != 0; p = p->left)
            travStack.push(p);
        while (p != 0 && (p->right == 0 || p->right == q)) {
            visit(p);
            q = p;
            if (travStack.empty())
                 return;
            p = travStack.pop();
        }
        travStack.push(p);
        p = p->right;
     }
}

template<class T>
void BST<T>::breadthFirst() {    
    Queue<BSTNode<T>*> queue;
    BSTNode<T> *p = root;
    if (p != 0) {
        queue.enqueue(p);
        while (!queue.empty()) {
            p = queue.dequeue();
            visit(p);
            if (p->left != 0)
                 queue.enqueue(p->left);
            if (p->right != 0)
                 queue.enqueue(p->right);
        }
    }
}

template<class T>
void BST<T>::MorrisInorder() {   
    BSTNode<T> *p = root, *tmp;
    while (p != 0)
        if (p->left == 0) {
             visit(p);
             p = p->right;
        }
        else {
             tmp = p->left;
             while (tmp->right != 0 &&// przejd do skrajnego prawego wza
                    tmp->right != p)  // lewego poddrzewa lub do tymczasowego
                  tmp = tmp->right;   // rodzica p;
             if (tmp->right == 0) {   // jeli 'true', osignito skrajny prawy
                  tmp->right = p;     // wze; uczy go tymczasowym rodzicem
                  p = p->left;        // za aktualnego;
             }
             else {                   // jeli nie, znaleziono tymczasowego
                  visit(p);           // rodzica; odwied wze p i potem 
                  tmp->right = 0;     // usu prawy wskanik biecego rodzica, 
                  p = p->right;       // gdy przestaje by rodzicem
             }
        }
}

template<class T>
void BST<T>::MorrisPreorder() {
    BSTNode<T> *p = root, *tmp;
    while (p != 0) {
        if (p->left == 0) {
             visit(p);
             p = p->right;
        }
        else {
             tmp = p->left;
             while (tmp->right != 0 &&// przejd do skrajnego prawego wza
                    tmp->right != p)  // lewego poddrzewa lub do tymczasowego
                  tmp = tmp->right;   // rodzica p;
             if (tmp->right == 0) {   // jeli 'true', osignito skrajny
                  visit(p);           // prawy wze; przejd do korzenia
                  tmp->right = p;     // i prawy skrajny wze uczy
                  p = p->left;        // tymczasowym rodzicem wza biecego
             }
             else {                   // jeli nie, znaleziono tymczasowego
                  tmp->right = 0;     // rodzica; wytnij z rodzica biecego
                  p = p->right;       // prawy wskanik, gdy przestaje on by
             }                        // rodzicem
        }
    }
}

template<class T>
void BST<T>::MorrisPostorder() {
    BSTNode<T> *p = new BSTNode<T>(), *tmp, *q, *r, *s;
    p->left = root;
    while (p != 0)
        if (p->left == 0)
             p = p->right;
        else {
             tmp = p->left;
             while (tmp->right != 0 &&// przejd do prawego skrajnego wza
                    tmp->right != p)  // lewego poddrzewa lub do tymczasowego
                  tmp = tmp->right;   // rodzica p;
             if (tmp->right == 0) {   // jeli 'true', osignito skrajny
                  tmp->right = p;     // prawy wze; uczy go tymczasowym
                  p = p->left;        // rodzicem aktualnego korzenia
             }
             else {           // jeli nie, znaleziono tymczasowego rodzica;
                  // przetwarzaj w odwrotnej kolejnoci wzy midzy p->left 
                  // (wcznie) a p (z wyczeniem) w prawej czci
                  // zmodyfikowanego drzewa; pierwsza ptla przechodzi
                  // po takim acuchu wzw i odwraca prawe wskaniki;
                  // druga ptla cofa si, przechodzi po wzach i ponownie
                  // odwraca prawe wskaniki, aby przywrci im oryginalne
                  // wartoci.
                  for (q = p->left, r = q->right, s = r->right;
                       r != p; q = r, r = s, s = s->right)
                      r->right = q;
                  for (s = q->right; q != p->left;
                      q->right = r, r = q, q = s, s = s->right)
                     visit(q);
                  visit(p->left);     // przejd do p->left i wytnij prawy
                  tmp->right = 0;     // wskanik rodzica aktualnego wza,
                  p = p->right;       // gdy przestaje on by rodzicem.
             }
        }
}

template<class T>
void BST<T>::balance (T data[], int first, int last) {
    if (first <= last) {
        int middle = (first + last)/2;
        insert(data[middle]);
        balance(data,first,middle-1);
        balance(data,middle+1,last);
    }
}

#endif
