//**************************  genThreaded.h  **********************
//                 Oglne binarne drzewo poszukiwania z wtkami

#ifndef THREADED_TREE
#define THREADED_TREE

template<class T>
class ThreadedNode {
public:
    ThreadedNode() { 
        left = right = 0; 
    }
    ThreadedNode(const T& el, ThreadedNode *l = 0, ThreadedNode *r = 0) {
        key = el; left = l; right = r; successor = 0; 
    }
    T key;
    ThreadedNode *left, *right;
    unsigned int successor : 1;
};

template<class T>
class ThreadedTree {
public:
    ThreadedTree()  {
        root = 0;
    }
    void clear() {
        clear(root); root = 0;
    }
    ~ThreadedTree() {
        clear();
    }
    void virtual visit(ThreadedNode<T>* p) { 
        cout << p->key << " ";
    } 
    void sideView() const {
        sideView(root,0);
    }
    void preorder();
    void inorder();
    void postorder();
    void insert(const T&);
protected:
    ThreadedNode<T>* root;
    void clear(ThreadedNode<T>*);
};

template<class T>
void ThreadedTree<T>::clear(ThreadedNode<T>*p)
{
    if (p != 0) {
         clear(p->left);
         if (p->successor == 0) // przejd w prawo tylko wtedy, gdy
              clear(p->right);  // jest to potomek
         delete p;
     }
}

template<class T>
void ThreadedTree<T>::insert(const T& el) {
    ThreadedNode<T> *p, *prev = 0, *newNode;
    newNode = new ThreadedNode<T>(el);
    if (root == 0) {              // drzewo jest puste
        root = newNode;
        return;
     }
     p = root;                    // znajd miejsce na newNode
     while (p != 0) {
         prev = p;
         if (p->key > el)
              p = p->left;
         else if (p->successor == 0) // przejd do prawego wza tylko, jeli
              p = p->right;          // jest potomkiem, a nie nastpnikiem
         else break;                 // nie id do nastpnika
     }
     if (prev->key > el) {        // jeli newNode jest lewym dzieckiem swojego
          prev->left  = newNode;  // rodzica, rodzic ten staje si take
          newNode->successor = 1; // nastpnikiem
          newNode->right = prev;
     }
     else if (prev->successor == 1) {// jeli rodzic newNode nie jest
          newNode->successor = 1; // skrajnym prawym wzem, uczy nastpnik
          prev->successor = 0;    // rodzica nastpnikiem newNode
          newNode->right = prev->right; 
          prev->right = newNode;
     }
     else prev->right = newNode;  // jeli nie, brak nastpnika
}

template<class T>
void ThreadedTree<T>::inorder() {
    ThreadedNode<T> *prev, *p = root;
    if (p != 0) {                 // przetwarzaj tylko niepuste drzewa
        while (p->left != 0)      // przejd do skrajnego lewego wza
            p = p->left;
        while (p != 0) {
            visit(p);
            prev = p;
            p = p->right;         // przejd do prawego wza tylko wtedy,
            if (p != 0 && prev->successor == 0) // gdy jest potomkiem
                while (p->left != 0)   // id do skrajnego lewego wza
                    p = p->left;  // jeli nie, odwied nastpnik
        }
    }
}

template<class T>
void ThreadedTree<T>::preorder() {
    ThreadedNode<T> *p = root;
	while (p != 0) {              // przetwarzanie tylko niepustych drzew
        visit(p);
        if (p->left != 0)
             p = p->left;
        else if (p->right != 0 && p->successor == 0)
             p = p->right;
        else {                    // jeli p jest liciem, przejd przez
             while (p->successor == 1) // acuch jego (ju odwiedzonych)
                 p = p->right;    // nastpnikw, zacznij od prawego
             p = p->right;        // potomka ostatniego nastpnika
        }
    }
}

template<class T>
void ThreadedTree<T>::postorder() {
    ThreadedNode<T> *q, *r, *s, *p = new ThreadedNode<T>, *rightmost, *dummy = p;
    p->left = root;
    for (rightmost = root; rightmost->right != 0; rightmost = rightmost->right);
    rightmost->successor = 1;
    rightmost->right = p;
    enum direction {goLeft, goRight, visiting} dir = goLeft;
    while (p != 0) {
        if (dir == goLeft)
             if (p->left != 0)
                  p = p->left;
             else dir = goRight;
        else if (dir == goRight)
             if (p->right != 0 && p->successor == 0) {
                  p = p->right;
                  dir = goLeft;
             }
             else dir = visiting;
        else {
             if (p == dummy) {
                  rightmost->right = 0; // przywr oryginaln warto
                  rightmost->successor = 0; // skrajnego prawego wza
                  delete dummy;
                  return;
             }
             visit(p);
             if (p->right != 0 && p->right->left == p) { // rodzic == nastpnik
                  p = p->right;
                  dir = goRight;
             }
             else {
                  // przejrzyj rozszerzony w prawo acuch wzw
                  // i odwr prawe wskaniki
                  for (q = p->right->left, r = q->right, s = r->right;
                       r != p; q = r, r = s, s = s->right)
                      r->right = q;
                  // przejrzyj w stecz acuch, odwiedzaj kady wze
                  // i przywr oryginaln warto prawych wskanikw
                  for (s = q->right; q != p->right->left;
                       q->right = r, r = q, q = s, s = s->right)
                      visit(q);
                  visit(q);
                  p = p->right;
                  dir = goRight;
             }
        }
    }
}

#endif
