//**************************  genSkipL.h  ***************************
//                     oglna klasa list z przeskokami

const int maxLevel = 4;

template<class T>
class SkipListNode {
public:
    SkipListNode() {
    }
    T key;
    SkipListNode **next;
};

template<class T>
class SkipList {
public:
    SkipList();
    bool isEmpty() const;
    void choosePowers();
    int  chooseLevel();
    T* skipListSearch(const T&);
    void skipListInsert(const T&);
private:
    typedef SkipListNode<T> *nodePtr;
    nodePtr root[maxLevel];
    int powers[maxLevel];
};

template<class T>
SkipList<T>::SkipList() {
    for (int i = 0; i < maxLevel; i++)
        root[i] = 0;
}

template<class T>
bool SkipList<T>::isEmpty() const {
    return root[0] == 0;
}

template<class T>
void SkipList<T>::choosePowers() {
    powers[maxLevel-1] = (2 << (maxLevel-1)) - 1;  // 2^maxLevel - 1
    for (int i = maxLevel - 2, j = 0; i >= 0; i--, j++)
        powers[i] = powers[i+1] - (2 << j);        // 2^(j+1)
}

template<class T>
int SkipList<T>::chooseLevel() {
    int i, r = rand() % powers[maxLevel-1] + 1;
    for (i = 1; i < maxLevel; i++)
        if (r < powers[i])
            return i-1; // zwr poziom < poziomu najmniejszego
    return i-1;         // zwr poziom najwyszy
}

template<class T>
T* SkipList<T>::skipListSearch(const T& key) {
    if (isEmpty())
	return 0;
    nodePtr prev, curr;
    int lvl;                            // znajd najwikszy niepusty
    for (lvl = maxLevel-1; lvl >= 0 && !root[lvl]; lvl--);  // poziom
    prev = curr = root[lvl];
    while (1) {
        if (key == curr->key)                   // jeli rwne, znaleziono
             return &curr->key;
        else if (key < curr->key) {             // jeli mniejsze, o ile
             if (lvl == 0)                      // moliwe, przejd niej
                  return 0;
             else if (curr == root[lvl])        // o jeden poziom
                  curr = root[--lvl];           // zaczynajc od poprzednika,
             else curr = *(prev->next + --lvl); // ktry moe by korzeniem
        }
        else {                                  // jeli wiksze, przejd
             prev = curr;                       // do nastpnego niepustego
             if (*(curr->next + lvl) != 0)      // wza tego samego poziomu
                  curr = *(curr->next + lvl);   // lub do listy poziomu
             else {                             // niszego
                  for (lvl--; lvl >= 0 && *(curr->next + lvl) == 0; lvl--);
                  if (lvl >= 0)
                       curr = *(curr->next + lvl);
                  else return 0;
             }
        }
    }
}

template<class T>
void SkipList<T>::skipListInsert(const T& key) {
    nodePtr curr[maxLevel], prev[maxLevel], newNode;
    int lvl, i;
    curr[maxLevel-1] = root[maxLevel-1];
    prev[maxLevel-1] = 0;
    for (lvl = maxLevel - 1; lvl >= 0; lvl--) {
        while (curr[lvl] && curr[lvl]->key < key) {// przejd do nastpnego,
            prev[lvl] = curr[lvl];                 // o ile mniejszy
            curr[lvl] = *(curr[lvl]->next + lvl);
        }
        if (curr[lvl] && curr[lvl]->key == key)    // nie wsawiaj powtrze
            return;
        if (lvl > 0)                               // przejd do niszego
             if (prev[lvl] == 0) {                 // poziomu, o ile
                  curr[lvl-1] = root[lvl-1];       // biecy nie jest 
                  prev[lvl-1] = 0;                 // najniszy; uyj powizania
             }                                     // z korzenia
             else {                                // lub poprzednika
                  curr[lvl-1] = *(prev[lvl]->next + lvl-1);
                  prev[lvl-1] = prev[lvl];
             }
    }
    lvl = chooseLevel();        // losowe wybierania poziomu dla newNode
    newNode = new SkipListNode<T>;
    newNode->next = new nodePtr[sizeof(nodePtr) * (lvl+1)];
    newNode->key  = key;
    for (i = 0; i <= lvl; i++) {        // inicjalizacja pl next dla
        *(newNode->next + i) = curr[i]; // newNode i ustawienie na newNode
        if (prev[i] == 0)               // pl next albo korzenia, albo 
             root[i] = newNode;         // albo poprzednikw newNode
        else *(prev[i]->next + i) = newNode;
    }
}

