#ifndef DOUBLY_LINKED_LIST
#define DOUBLY_LINKED_LIST

template<class T>
class Node {
public:
    Node() {
       	next = prev = 0;
    }
    Node(const T& el, Node *n = 0, Node *p = 0) {
        info = el; next = n; prev = p;
    }
    T info;
    Node *next, *prev;
};

template<class T>
class DoublyLinkedList {
public:
    DoublyLinkedList() {
        head = tail = 0;
    }
    void addToDLLTail(const T&);
    T deleteFromDLLTail();
    bool isEmpty() const {
        return head == 0;
    }
    void clear();
    void setToNull() {
        head = tail = 0;
    }
    void addToDLLHead(const T&);
    T deleteFromDLLHead();
    T& firstEl();
    T* find(const T&) const;
    void printAll();
protected:
    Node<T> *head, *tail;
};

template<class T>
void DoublyLinkedList<T>::addToDLLHead(const T& el) {
    if (head != 0) {
         head = new Node<T>(el,head,0);
         head->next->prev = head;
    }
    else head = tail = new Node<T>(el);
}

template<class T>
void DoublyLinkedList<T>::addToDLLTail(const T& el) {
    if (tail != 0) {
         tail = new Node<T>(el,0,tail);
         tail->prev->next = tail;
    }
    else head = tail = new Node<T>(el);
}

template<class T>
T DoublyLinkedList<T>::deleteFromDLLHead() {
    T el = head->info;
    if (head == tail) { // gdy na licie jest tylko jeden wze
         delete head;
         head = tail = 0;
    }
    else {              // gdy na licie jest wicej ni jeden wze
         head = head->next;
         delete head->prev;
         head->prev = 0;
    }
    return el;
}

template<class T>
T DoublyLinkedList<T>::deleteFromDLLTail() {
    T el = tail->info;
    if (head == tail) { // gdy na licie jest tylko jeden wze
         delete head;
         head = tail = 0;
    }
    else {              // gdy na licie jest wicej ni jeden wze
         tail = tail->prev;
         delete tail->next;
         tail->next = 0;
    }
    return el;
}

template<class T>
T* DoublyLinkedList<T>::find(const T& el) const {
    Node<T> *tmp;
    for (tmp = head; tmp != 0 && !(tmp->info == el);  // przeciony ==
         tmp = tmp->next);
    if (tmp == 0)
         return 0;
    else return &tmp->info;
}

template<class T>
T& DoublyLinkedList<T>::firstEl() {
    return head->info;
}

template<class T>
void DoublyLinkedList<T>::clear() {
    for (Node<T> *tmp; head != 0; ) {
        tmp = head;
	head = head->next;
        delete tmp;
    }
}

template<class T>
void DoublyLinkedList<T>::printAll() {
    for (Node<T> *tmp = head; tmp != 0; tmp = tmp->next)
        cout << tmp->info << ' ';
}

#endif
