﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter11.Listing11_02
{
#pragma warning disable 0168 // Wyłączenie ostrzeżeń o nieużywanych zmiennych
    using System;
    using System.ComponentModel;

    public sealed class Program
    {
        public static void Main(string[] args)
        {
            try
            {
                //throw new Win32Exception(42);
                // ...
                //TextNumberParser.Parse("negative forty-two");
                // ...
                throw new InvalidOperationException(
                    "Dowolny wyjątek");
                // ...
            }
            catch(Win32Exception exception) 
                when(exception.NativeErrorCode  == 42)
            {
                // Obsługa wyjątku typu Win32Exception, gdy 
                // właściwość NativeErrorCode ma wartość 42.
            }
            catch (ArgumentException exception)
            {
                // Obsługa wyjątków typu ArgumentException.
            }
            catch (InvalidOperationException exception)
            {
                // Obsługa wyjątków typu InvalidOperationException.
            }
            catch (Exception exception)
            {
                // Obsługa wyjątków typu Exception.
            }
            finally
            {
                // Tu umieść kod porządkujący zasoby. Ten kod 
                // jest wykonywany niezależnie od tego, czy wystąpił wyjątek.
            }
        }
    }
}