﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter11.Listing11_01
{
    using System;

    public sealed class TextNumberParser
    {
        public static int Parse(string textDigit)
        {
            string[] digitTexts =
      { "zero", "jeden", "dwa", "trzy", "cztery",
        "pięć", "sześć", "siedem", "osiem", "dziewięć" };

#if !PRECSHARP7
            int result = Array.IndexOf(
                digitTexts,
                // Wykorzystanie operatora ?? z C# 2.0
                (textDigit ??
                  // Wykorzystanie wyrażenia throw z C# 7.0
                  throw new ArgumentNullException(nameof(textDigit))
                ).ToLower());

#else
            if(textDigit == null) throw new ArgumentNullException(nameof(textDigit))
            int result = Array.IndexOf(
                digitTexts, textDigit?.ToLower());
#endif

            if (result < 0)
            {
#if !PRECSHARP6
                throw new ArgumentException(
                    "Argument nie reprezentuje cyfry", nameof(textDigit));
#else
                throw new ArgumentException(
                    "Argument nie reprezentuje cyfry",
                    "textDigit");
#endif
            }

            return result;
        }
    }
}