// Ignorowanie ostrzeżenia o dodawaniu modyfikatora readonly, ponieważ nie został on jeszcze omówiony
#pragma warning disable IDE0044
#pragma warning disable 649 // _Id nie ma przypisanej wartości

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_31
{
    public class Employee
    {
        public Employee(string firstName, string lastName)
        {
            FirstName = firstName;
            LastName = lastName;
        }

        public Employee(
            int id, string firstName, string lastName)
        {
            Id = id;
            FirstName = firstName;
            LastName = lastName;
        }

        // FirstName i LastName są ustawiane w setterze właściwości Id.
#pragma warning disable CS8618
        public Employee(int id) => Id = id;
#pragma warning restore CS8618

        private int _Id;
        public int Id
        {
            get => _Id;
            private set
            {
                // Sprawdzanie imienia pracownika...
                // ...
            }
        }
        [System.Diagnostics.CodeAnalysis.NotNull]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FirstName { get; set; }
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        [System.Diagnostics.CodeAnalysis.NotNull]
        public string LastName { get; set; }
        public string? Salary { get; set; } = "Za niskie";


        // ...
    }
}
