// Pole niedopuszczające null nie jest zainicjowane. Rozważ deklarację pola dopuszczającego null
#pragma warning disable CS8618 

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_23
{
    class Program
    {
        static void Main()
        {
            Employee employee1 = new Employee();
            employee1.Initialize(42);
            // BŁĄD: nie można użyć właściwości ani indeksera 'Employee.Id' 
            // w tym kontekście, ponieważ setter jest niedostępny.
            // employee1.Id = "490";                     // Jeśli przeniesiesz ten wiersz poza komentarz, kod się nie skompiluje
        }
    }

    class Employee
    {
        public void Initialize(int id)
        {
            // Ustawianie właściwości Id.
            Id = id.ToString();
        }

        // ...
        // Deklaracja właściwości Id.
        public string Id
        {
            get => _Id;
            private set => _Id = value;
        }
        private string _Id;
    }
}
