namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_09
{
    using System;
    using System.Reflection;
    using System.Threading;

    class Program
    {
        public static void Main()
        {
            // Tworzenie nazwy muteksu na podstawie
            // pełnej nazwy podzespołu.
            string mutexName =
                Assembly.GetEntryAssembly()!.FullName!;

            // Parametr firstApplicationInstance określa, czy 
            // dana instancja aplikacji jest pierwszą instancją
            using Mutex mutex = new Mutex(false, mutexName,
                 out bool firstApplicationInstance);

            if (!firstApplicationInstance)
            {
                Console.WriteLine(
                    "Ta aplikacja już działa.");
            }
            else
            {
                Console.WriteLine("Wciśnij ENTER, aby zakończyć");
                Console.ReadLine();
            }
        }
    }
}
