// Pole niedopuszczające null nie jest inicjowane; rozważ zadeklarowanie go jako dopuszczającego null
#pragma warning disable CS8618

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_09
{
    public class PdaItem
    {
        public virtual string Name { get; set; }
        // ...
    }

    public class Contact : PdaItem
    {
        public override string Name
        {
            get
            {
                return $"{ FirstName } { LastName }";
            }

            set
            {
                string[] names = value.Split(' ');
                // Obsługa błędów została pominięta
                FirstName = names[0];
                LastName = names[1];
            }
        }

        public string FirstName { get; set; }
        public string LastName { get; set; }

        // ...
    }
}
