namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_04
{
    using AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    public class Program
    {
        public static void Main()
        {
            ShowContextualKeywords2();
        }

        private static void ShowContextualKeywords2()
        {
            IEnumerable<string> selection = from word in CSharp.Keywords
                                            where IsKeyword(word)
                                            select word;
            Console.WriteLine("Kwerenda została utworzona.");
            foreach(string keyword in selection)
            {
                // Ten kod nie generuje spacji. 
                Console.Write(keyword);
            }
        }

        // Efekt uboczny w postaci wyświetlania danych wyjściowych w konsoli
        // jest generowany za pomocą predykatu. Pozwala to zilustrować opóźnione wykonywanie.
        // W kodzie produkcyjnym należy unikać predykatów powodujących efekty uboczne. 
        private static bool IsKeyword(string word)
        {
            if(word.Contains('*'))
            {
                Console.Write(" ");
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}