using System;
using System.Runtime.Serialization;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter11.Listing11_04
{

    class DatabaseException : Exception
    {
        public DatabaseException(
            string? message,
            System.Data.SqlClient.SQLException? exception)
            : base(message, innerException: exception)
        {
            // ...
        }

        public DatabaseException(
            string? message,
            System.Data.OracleClient.OracleException? exception)
            : base(message, innerException: exception)
        {
            // ...
        }

        public DatabaseException()
        {
            // ...
        }

        public DatabaseException(string? message)
            : base(message)
        {
            // ...
        }

        public DatabaseException(
            string? message, Exception? exception)
            : base(message, innerException: exception)
        {
            // ...
        }

        // Służy do deserializacji wyjątków
        public DatabaseException(
            SerializationInfo serializationInfo,
            StreamingContext context)
            : base(serializationInfo, context)
        {
            //...
        }
    }

    // Tworzenie atrap klas wyjątków bazodanowych zamiast
    // używania referencji do prawdziwych bibliotek
#pragma warning disable CA1032 // Zaimplementuj standardowe konstruktory wyjątków
    namespace System.Data
    {
        namespace SqlClient
        {
            class SQLException : Exception
            {
            }
        }
        namespace OracleClient
        {
            class OracleException : Exception
            {
            }
        }
    }
#pragma warning restore CA1032 // Zaimplementuj standardowe konstruktory wyjątków
}

