﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_07
{
    interface IReadableSettingsProvider
    {
        string GetSetting(string name, string defaultValue);
    }

    interface ISettingsProvider : IReadableSettingsProvider
    {
        // BŁĄD: metoda GetSetting() nie pochodzi z interfejsu ISettingsProvider.

        //string ISettingsProvider.GetSetting(
        //    string name, string defaultValue)
        //{
        //    ...
        //}

        void SetSetting(string name, string value);
    }

    class FileSettingsProvider : ISettingsProvider
    {
        #region Składowe z interfejsu ISettingsProvider
        public void SetSetting(string name, string value)
        {
            // ...
        }
        #endregion

        #region Składowe z interfejsu IReadableSettingsProvider
        public string GetSetting(string name, string defaultValue)
        {
            return name + defaultValue; // Zwracanie wartości na potrzeby przykładu
        }
        #endregion
    }

}
