
namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter20.Listing20_11
{
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using System;
    using System.Text.RegularExpressions;
    using System.Threading.Tasks;
    using AddisonWesley.Michaelis.EssentialCSharp.Chapter20.Listing20_09;

    [TestClass]
    public class ProgramTests
    {

        [TestMethod]
        public void AsyncVoidReturnTest()
        {
            string expected = $@"Wywołanie Task.Run...(ID wątku: *)
Wykonywanie zadania... (ID wątku: *)
Powiadomienie w metodzie Post...(ID wątku: *)
Powiadomienie w metodzie Post...(ID wątku: *)
Zgłaszanie oczekiwanego wyjątku....(ID wątku: *)
System.Exception: Oczekiwany wyjątek
   *(ID wątku: *)";

            string output = IntelliTect.TestTools.Console.ConsoleAssert.ExpectLike(
                expected,
                () =>
                {
                    Program.Main();
                }
            );

            Assert.IsTrue(Program.EventTriggered);

            Console.WriteLine(output);

            // Sprawdzanie, czy tylko identyfikator wątku z Wykonywanie zadania (drugi wiersz) jest unikatowy
            MatchCollection matches = Regex.Matches(output, @"\(ID wątku: (\d)+\)");
            int firstThreadId = int.Parse(matches[0].Groups[1].Value);
            int secondThreadId = int.Parse(matches[1].Groups[1].Value);
            int? expectedThreadId;
            for (int i = 0; i < matches.Count; i++)
            {
                switch (i)
                {
                    case 0:
                    case 4:
                    case 5:
                        expectedThreadId = firstThreadId;
                        break;
                    case 1:
                        // Oczywiste
                        expectedThreadId = secondThreadId;
                        break;
                    default:
                        // Nieznany
                        expectedThreadId = null;
                        break;
                }
                if (expectedThreadId != null)
                {
                    Assert.AreEqual<int?>(expectedThreadId, int.Parse(matches[i].Groups[1].Value),
                        $"Dopasowanie {i} to '{matches[i].Groups[0].Value}'; oczekiwano '{expectedThreadId}'.");
                }
            }
            Assert.AreEqual<int>(6, matches.Count, "Mniej dopasowanych identyfikatorów wątku niż oczekiwano.");
        }
    }
}
