﻿using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter18.Listing18_03.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_WithNoParameters_DisplaysHelp()
        {
            string expected = @"
Compress.exe /Out:< nazwa pliku > /Help /Priority:RealTime | High | AboveNormal | Normal | BelowNormal | Idle";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected,
            () =>
            {
                Program.Main(new string[]{ });
            });
        }

        [TestMethod]
        public void Main_NormalCompression_Succes()
        {
            string expected = @"Wykonywanie testhost.dll /Out:output.dat /Priority:High";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected,
            () =>
            {
                Program.Main(new string[] {"/Out:output.dat", "/Priority:high"});
            });
        }

        [TestMethod]
        public void Main_InvalidCompression_Succes()
        {
            string expected = @"Opcja 'Invalid' jest nieprawidłowa dla 'Priority'
Compress.exe /Out:< nazwa pliku > /Help /Priority:RealTime | High | AboveNormal | Normal | BelowNormal | Idle";
            IntelliTect.TestTools.Console.ConsoleAssert.Expect(expected,
            () =>
            {
                Program.Main(new string[] { "/Out:output.dat", "/Priority:Invalid" });
            });
        }

    }
}