namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter17.Listing17_20
{
    using System;
    using Listing17_10;
    using System.Collections.Generic;

    public class Program
    {
        public static void Main()
        {
            var game = new Pair<string>("Redskins", "Eagles");
            foreach(string name in game.GetReverseEnumerator())
            {
                Console.WriteLine(name);
            }
        }
    }

    public struct Pair<T> : IPair<T>, IEnumerable<T>
    {
        #region Składowe
        public Pair(T first, T second)
        {
            First = first;
            Second = second;
        }
        public T First { get; }
        public T Second { get; }

        public T this[PairItem index]
        {
            get
            {
                switch(index)
                {
                    case PairItem.First:
                        return First;
                    case PairItem.Second:
                        return Second;
                    default:
                        throw new NotImplementedException(
                            string.Format(
                            "Wyliczenie nie zawiera wartości { 0 }.",
                            index.ToString()));
                }
            }
        }
        #endregion Składowe

        //Listing 17.20. Używanie instrukcji yield return w metodzie zwracającej obiekt typu IEnumerable<T>
        public IEnumerable<T> GetReverseEnumerator()
        {
            yield return Second;
            yield return First;
        }
        //Listing 17.20. Używanie instrukcji yield return w metodzie zwracającej obiekt typu IEnumerable<T>

        //Listing 17.18. Unikanie iteracji za pomocą instrukcji yield break
        public System.Collections.Generic.IEnumerable<T> GetNotNullEnumerator()
        {
            if((First == null) || (Second == null))
            {
                yield break;
            }
            yield return Second;
            yield return First;
        }
        //Listing 17.18. Unikanie iteracji za pomocą instrukcji yield break


        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            yield return First;
            yield return Second;
        }
        #endregion IEnumerable<T>

        #region Składowe z interfejsu IEnumerable
        System.Collections.IEnumerator
            System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion
    }
}
