using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter15.Listing15
{
    public class Patent
    {
        // Tytuł opublikowanego wniosku.
        public string Title { get; }

        // Data oficjalnego opublikowania wniosku.
        public string YearOfPublication { get; }

        // Unikatowy numer przypisany do opublikowanego wniosku.
        public string? ApplicationNumber { get; set; }

        public long[] InventorIds { get; }

        public Patent(
            string title, string yearOfPublication, long[] inventorIds)
        {
            Title = title ?? throw new ArgumentNullException(nameof(title));
            YearOfPublication = yearOfPublication ?? 
                throw new ArgumentNullException(nameof(yearOfPublication));
            InventorIds = inventorIds ?? 
                throw new ArgumentNullException(nameof(inventorIds));
        }

        public override string ToString()
        {
            return $"{ Title } ({ YearOfPublication })";
        }

    }

    public class Inventor
    {
        public long Id { get; }
        public string Name { get; }
        public string City { get; }
        public string State { get; }
        public string Country { get; }

        public Inventor(
            string name, string city, string state, string country, int id)
        {
            Name = name ?? throw new ArgumentNullException(nameof(name));
            City = city ?? throw new ArgumentNullException(nameof(city));
            State = state ?? throw new ArgumentNullException(nameof(state));
            Country = country ?? throw new ArgumentNullException(nameof(country));
            Id = id;
        }

        public override string ToString()
        {
            return $"{ Name } ({ City }, { State })";
        }

    }

    public static class PatentData
    {
        public static readonly Inventor[] Inventors = new Inventor[]
        {
            new Inventor(
                "Benjamin Franklin", "Philadelphia",
                "PA", "USA", 1),
            new Inventor(
                "Orville Wright", "Kitty Hawk",
                "NC", "USA", 2),
            new Inventor(
                "Wilbur Wright", "Kitty Hawk",
                "NC", "USA", 3),
            new Inventor(
                "Samuel Morse", "Nowy Jork",
                "NY", "USA", 4),
            new Inventor(
                "George Stephenson", "Wylam",
                "Northumberland", "UK", 5),
            new Inventor(
                "John Michaelis", "Chicago",
                "IL", "USA", 6),
            new Inventor(
                "Mary Phelps Jacob", "Nowy Jork",
                "NY", "USA", 7)
        };

        public static readonly Patent[] Patents = new Patent[]
        {
            new Patent("Okulary dwuogniskowe","1784", inventorIds: new long[] { 1 }),
            new Patent("Fonograf", "1877", inventorIds: new long[] { 1 }),
            new Patent("Kinetoskop", "1888", inventorIds: new long[] { 1 }),
            new Patent("Telegraf elektryczny", "1837", inventorIds: new long[] { 4 }),
            new Patent("Maszyna latająca", "1903", inventorIds: new long[] { 2, 3 }),
            new Patent("Lokomotywa parowa", "1815", inventorIds: new long[] { 5 }),
            new Patent("Mechanizm nakładania kropelek", "1989", inventorIds: new long[] { 6 }),
            new Patent("Biustonosz bez pleców", "1914", inventorIds: new long[] { 7 })
        };
    }
}
