﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_04
{
    using System;

    public class Thermostat
    {
        // Definicja metody publikującej zdarzenia
        public Action<float>? OnTemperatureChange { get; set; }

        public float CurrentTemperature
        {
            get { return _CurrentTemperature; }
            set
            {
                if(value != CurrentTemperature)
                {
                    _CurrentTemperature = value;

                    // NIEKOMPLETNE: trzeba sprawdzać, czy wartość jest różna od null.
                    // Wywołanie kierowane do subskrybentów.
#pragma warning disable CS8602 // Dereferencja referencji, która może być równa null.
                    OnTemperatureChange(value);
#pragma warning restore CS8602 // Dereferencja referencji, która może być równa null.
                }
            }
        }
        private float _CurrentTemperature;
    }
}