namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter12.Listing12_22
{
    using System;
    using Listing12_13;

    public class BinaryTree<T>
        where T : System.IComparable<T>
    {
        public BinaryTree(T item)
        {
            Item = item;
        }

        public T Item { get; set; }

        public Pair<BinaryTree<T>> SubItems
        {
            get { return _SubItems; }
            set
            {
                switch (value)
                {
                    case { First: null }:
                        // First to null
                        break;
                    case { Second: null }:
                        // Second to null
                        break;
                    case
                    {
                        First: { Item: T first },
                        Second: { Item: T second }
                    }:
                        if (first.CompareTo(second) < 0)
                        {
                            // Element first jest mniejszy niż second.
                        }
                        else
                        {
                            // Element second jest mniejszy lub równy względem first.
                        }
                        break;
                    default:
                        throw new InvalidCastException(
            @$"Nie da się posortować elementów. Typ {
              typeof(T) } nie obsługuje interfejsu IComparable<T>");
                };
                _SubItems = value;
            }
        }
        private Pair<BinaryTree<T>> _SubItems;

    }
}
