﻿// Wyjaśnienie - listing jest niekompletny z powodów edukacyjnych
#pragma warning disable IDE0060 // Usuwanie nieużywanego parametru
namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_04
{
    using System;

    public class Program
    {
        public static void Main()
        {
            //...

            Coordinate coordinate1 =
                new Coordinate(new Longitude(48, 52),
                               new Latitude(-2, -20));

            // Obiekty typów bezpośrednich nigdy nie są równe ze względu na referencje.
            if (Coordinate.ReferenceEquals(coordinate1,
                coordinate1))
            {
                throw new Exception(
                    "coordinate1 jest równa ze względu na referencje z coordinate1");
            }

            Console.WriteLine(
                "coordinate1 NIE jest równa ze względu na referencje z sobą samą");
        }
    }

    public struct Coordinate
    {
        public Coordinate(Longitude longitude, Latitude latitude)
        {
            Longitude = longitude;
            Latitude = latitude;
        }

        public Longitude Longitude { get; }
        public Latitude Latitude { get; }


        // ...
    }

    public struct Longitude
    {
        public Longitude(int x, int y) { }
    }
    public struct Latitude
    {
        public Latitude(int x, int y) { }
    }
}