namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_11
{
    using Listing08_09;

    interface IDistributedSettingsProvider : ISettingsProvider
    {
        /// <summary>
        /// Pobieranie ustawień dla konkretnego identyfikatora URI.
        /// </summary>
        /// <param name="uri">
        /// Identyfikator URI, którego dotyczą ustawienia.</param>
        /// <param name="name">Nazwa ustawienia.</param>
        /// <param name="defaultValue">
        /// Wartość zwracana, gdy nie można znaleźć danego ustawienia.</param>
        /// <returns>Określone ustawienie.</returns>
        string GetSetting(
            string uri, string name, string defaultValue);

        /// <summary>
        /// Określanie ustawienia dla konkretnego identyfikatora URI.
        /// </summary>
        /// <param name="uri">
        /// Identyfikator URI, którego dotyczy ustawienie.</param>
        /// <param name="name">Nazwa ustawienia.</param>
        /// <param name="value">Zapisywana wartość.</param>
        /// <returns>Określone ustawienie.</returns>
        void SetSetting(
            string uri, string name, string value);
    }
}
