﻿// Wyjaśnienie - pokazane są tylko fragmenty kodu w celach edukacyjnych
#pragma warning disable CS0168 // Zmienna jest deklarowana, ale nie jest używana

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter03.Table03_02
{
    public class ArrayHighlights
    {
        // 1.
        static public void Declaration()
        {
            string[] languages; // Jednowymiarowa
            int[,] cells;       // Dwuwymiarowa
        }

        // 2.
        static public void Assignment()
        {
            string[] languages = { "C#", "COBOL", "Java",
                "C++", "TypeScript", "Pascal",
                "Python", "Lisp", "JavaScript"};
            languages = new string[9];
            languages = new string[]{"C#", "COBOL", "Java",
                "C++", "TypeScript", "Pascal",
                "Python", "Lisp", "JavaScript" };
            // Inicjowanie tablic wielowymiarowych
            // i przypisywanie do nich wartości.
            int[,] cells = new int[3, 3] {
                { 1, 0, 2},
                { 1, 2, 0},
                { 1, 2, 1}
            };
        }

        // 3.
        static public void ForwardAndReverseAccessingAnArray()
        {
            string[] languages = new string[]{
                "C#", "COBOL", "Java",
                "C++", "TypeScript", "Visual Basic",
                "Python", "Lisp", "JavaScript"};
            // Pobieranie piątego elementu tablicy 
            // languages (TypeScript)..
            string language = languages[4];
            // Wyświetli  “TypeScript”
            System.Console.WriteLine(language);
            // Pobieranie trzeciego elementu 
            // od końca (Python).
            language = languages[^3];
            // Wyświetli “Python”
            System.Console.WriteLine(language);
        }

        // 4.
        static public void Ranges()
        {
            string[] languages = new string[]{
                "C#", "COBOL", "Java",
                "C++", "TypeScript", "Visual Basic",
                "Python", "Lisp", "JavaScript"};

            System.Console.WriteLine($@"^3..^0: {
                // Python, Lisp, JavaScript
                string.Join(", ", languages[^3..^0])
            }");
            System.Console.WriteLine($@"^3..: {
                // Python, Lisp, JavaScript
                string.Join(", ", languages[^3..])
            }");
            System.Console.WriteLine($@" 3..^3: {
                // C++, TypeScript, Visual Basic
                string.Join(", ", languages[3..^3])
            }");
            System.Console.WriteLine($@"  ..^6: {
                // C#, COBOL, Java
                string.Join(", ", languages[..^6])
            }");
        }
    }
}
