using Microsoft.VisualStudio.TestTools.UnitTesting;
using static AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_01.Tests.ProgramTests;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_02
{
    [TestClass]
    public class ProgramTests
    {

        [TestMethod]
        public void MainVerifyOutputIncrementAndDecrement()
        {
            VerifyOutputIncrementAndDecrement(Program.Main);
        }

        /// <summary>
        /// Informuje, czy operacje inkrementacji/dekremetancji są nieatomowe.
        /// WAŻNE: używane jest Inconclusive, ponieważ może się zdarzyć, że liczba inkrementacji i
        /// dekrementacji jest taka sama, jednak nie dowodzi to synchronizacji (nie da się jej
        /// dowieść za pomocą wykonywania kodu).
        /// </summary>
        [TestMethod]
        public void UnsynchronizedIncrementAndDecrement()
        {
            bool isUnsynchronized = IsIncrementDecrementNotAtomic(Program.Main);
            if (!isUnsynchronized)
            {
                Assert.Inconclusive("Nieoczekiwanie liczba inkrementacji i dekrementacji była taka sama, choć nie zastosowano blokad.");
            }
        }
    }
}
