namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter17.Listing17_12
{
    using System.Collections;
    using System.Collections.Generic;

    public class BinaryTree<T> :
    IEnumerable<T>
    {
        public BinaryTree(T value)
        {
            Value = value;
        }

        #region IEnumerable<T>
        public IEnumerator<T> GetEnumerator()
        {
            // ...
            return new List<T>.Enumerator(); // Implementacja w 16.16
        }
        IEnumerator IEnumerable.GetEnumerator()
        {
            // ...
            return GetEnumerator(); // Implementacja w 16.16
        }
        #endregion IEnumerable<T>

        public T Value { get; }  // Automatycznie generowana właściwość z samym getterem (z wersji C# 6.0). 
        public Pair<BinaryTree<T>> SubItems { get; set; }
    }

    public struct Pair<T>
    {
        public Pair(T first, T second) : this()
        {
            First = first;
            Second = second;
        }
        public T First { get; }  // Automatycznie generowana właściwość z samym getterem (z wersji C# 6.0). 
        public T Second { get; } // Automatycznie generowana właściwość z samym getterem (z wersji C# 6.0). 

    }
}
