﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_09
{
    using System;
    using Listing14_01;
    using Listing14_05;

    public class Program
    {
        public static void Main()
        {
            Thermostat thermostat = new Thermostat();
            Heater heater = new Heater(60);
            Cooler cooler = new Cooler(80);
            string temperature;

            // Składnia dla wersji C# 2.0 i nowszych
            thermostat.OnTemperatureChange +=
                heater.OnTemperatureChanged;
            // Kod dla wersji C# 3.0. Jeśli używasz wersji C# 2.0,
            // zastosuj metodę anonimową.
            thermostat.OnTemperatureChange +=
                (newTemperature) =>
                    {
                        throw new InvalidOperationException();
                    };
            thermostat.OnTemperatureChange +=
                cooler.OnTemperatureChanged;

            Console.Write("Podaj temperaturę: ");
            temperature = Console.ReadLine();
            thermostat.CurrentTemperature = int.Parse(temperature);
        }
    }
}