namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter06.Listing06_32
{
    public class Employee
    {
        public Employee(string firstName, string lastName)
        {
            FirstName = firstName;
            LastName = lastName;
        }

        public Employee(
            int id, string firstName, string lastName)
            : this(firstName, lastName)
        {
            Id = id;
        }

        // FirstName i LastName są ustawiane w setterze właściwości Id.
#pragma warning disable CS8618
        public Employee(int id)
        {
            Id = id;

            // Sprawdzanie imienia pracownika...
            // ...

            // UWAGA: konstruktorów nie można 
            // jawnie wywoływać wewnątrzwierszowo.
            // this(id, firstName, lastName);
        }
#pragma warning restore CS8618

        public int Id { get; private set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string? Salary { get; set; } = "Za niskie";

        // ...
    }
}
