#pragma warning disable CS1058 // Wcześniejszy blok catch już przechwytuje wszystkie wyjątki
#pragma warning disable CS0168 // Zmienna jest deklarowana, ale nie jest używana
namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_25
{
    public class ExceptionHandling
    {
        public static int Main()
        {
            string firstName;
            string ageText;
            int age;
            int result = 0;

            System.Console.Write("Wprowadź imię: ");
            firstName = System.Console.ReadLine();

            System.Console.Write("Wprowadź nazwisko: ");
            ageText = System.Console.ReadLine();

            try
            {
                age = int.Parse(ageText);
                System.Console.WriteLine(
                    $"Hej, { firstName }! Twój wiek w miesiącach to { age * 12 }.");
            }
            catch(System.FormatException exception)
            {
                System.Console.WriteLine(
                    $"Wprowadzony wiek, { ageText }, jest nieprawidłowy.");
                result = 1;
            }
            catch(System.Exception exception)
            {
                System.Console.WriteLine(
                    $"Nieoczekiwany błąd: { exception.Message }");
                result = 1;
            }
            catch
            {
                System.Console.WriteLine("Nieoczekiwany błąd!");
                result = 1;
            }
            finally
            {
                System.Console.WriteLine($"Żegnaj, { firstName }!");
            }

            return result;
        }
    }
}
