using IntelliTect.TestTools.Console;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter04.Listing04_22.Tests
{
    [TestClass]
    public class ProgramTests
    {
        [TestMethod]
        public void Main_InputOfNegative1_Exit()
        {
            const string expected =
                @"Zamykanie programu...";

            ConsoleAssert.Expect(
                expected, ()=>Program.Main("-1"));
        }
        
        [TestMethod]
        public void Main_Input10_AnswerTooHigh()
        {
            const string expected =
                @"Maksymalna liczba ruchów w grze w kółko i krzyżyk jest mniejsza niż 10.";

            ConsoleAssert.Expect(
                expected, ()=>Program.Main("10"));
        }
        
        [TestMethod]
        public void Main_Input5_AnswerTooLow()
        {
            const string expected =
                @"Maksymalna liczba ruchów w grze w kółko i krzyżyk jest większa niż 5.";

            ConsoleAssert.Expect(
                expected, ()=>Program.Main("5"));
        }

        [TestMethod]
        public void Main_Input9_CorrectAnswer()
        {
            const string expected =
                @"Dobrze, maksymalna liczba ruchów w grze w kółko i krzyżyk wynosi 9.";

            ConsoleAssert.Expect(
                expected, ()=>Program.Main("9"));
        }
    }
}