namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter22.Listing22_01
{
    using System;
    using System.Threading;
    using System.Threading.Tasks;

    public class Program
    {
        static int _Total = int.MaxValue;
        static int _Count = 0;

        public static int Main(string[] args)
        {
            if (args?.Length > 0) { int.TryParse(args[0], out _Total); }

            Console.WriteLine($"Liczba inkrementacji i dekrementacji: {_Total}");

            // W wersji .NET 4.0 zastosuj metodę Task.Factory.StartNew.
            Task task = Task.Run(() => Decrement());

            // Inkrementacja
            for (int i = 0; (i < _Total); i++)
            {
                _Count++;
            }

            task.Wait();
            Console.WriteLine($"Count = {_Count}");

            return _Count;
        }

        static void Decrement()
        {
            // Dekrementacja
            for (int i = 0; i < _Total; i++)
            {
                _Count--;
            }
        }
    }
}
