namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter17.Listing17_02
{
    using System;
    using System.Collections.Generic;

    public class Program
    {
        public static void Main()
        {
            List<Contact> list = new List<Contact>
            {

                // Listy są automatycznie powiększane 
                // wraz z dodawaniem elementów
                new Contact("Apsik", "Krasnal"),
                new Contact("Wesołek", "Krasnal"),
                new Contact("Gapcio", "Krasnal"),
                new Contact("Mędrek", "Krasnal"),
                new Contact("Śpioszek", "Krasnal"),
                new Contact("Nieśmiałek", "Krasnal"),
                new Contact("Gburek", "Krasnal"),
                new Contact("Duplikat", "Krasnal"),
                new Contact("Duplikat", "Krasnal")
            };

            IComparer<Contact> comparer = new NameComparison();

            list.Sort(comparer);

            foreach(Contact dwarf in list)
            {
                Console.WriteLine(dwarf.LastName + ", " + dwarf.FirstName);
            }
        }
    }

    class NameComparison : IComparer<Contact>
    {
        public int Compare(Contact? x, Contact? y)
        {
            if(Object.ReferenceEquals(x, y))
                return 0;
            if(x == null)
                return 1;
            if(y == null)
                return -1;
            int result = StringCompare(x.LastName, y.LastName);
            if(result == 0)
                result = StringCompare(x.FirstName, y.FirstName);
            return result;
        }

        private static int StringCompare(string? x, string? y)
        {
            if(Object.ReferenceEquals(x, y))
                return 0;
            if(x == null)
                return 1;
            if(y == null)
                return -1;
            return x.CompareTo(y);
        }
    }

    class Contact
    {
        public string FirstName { get; private set; }
        public string LastName { get; private set; }

        public Contact(string firstName, string lastName)
        {
            this.FirstName = firstName;
            this.LastName = lastName;
        }
    }
}
