namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16_05
{
    using AddisonWesley.Michaelis.EssentialCSharp.Chapter16.Listing16;
    using System;
    using System.Collections.Generic;
    using System.Linq;

    public class Program
    {
        public static void Main()
        {
            CountContextualKeywords();
        }

        private static void CountContextualKeywords()
        {
            int delegateInvocations = 0;
            string func(string text)
            {
                delegateInvocations++;
                return text;
            }

            IEnumerable<string> selection =
                from keyword in CSharp.Keywords
                where keyword.Contains('*')
                select func(keyword);


            Console.WriteLine(
                $"1. delegateInvocations={ delegateInvocations }");

            // Wywołanie metody Count powinno spowodować wykonanie funkcji func raz
            // dla każdego pobranego elementu.
            Console.WriteLine(
                $"2. Kontekstowe słowo kluczowe Count={ selection.Count() }");

            Console.WriteLine(
                $"3. delegateInvocations={ delegateInvocations }");

            // Wywołanie metody Count powinno spowodować wykonanie funkcji func raz
            // dla każdego pobranego elementu.
            Console.WriteLine(
                $"4. Kontekstowe słowo kluczowe Count={ selection.Count() }");

            Console.WriteLine(
                $"5. delegateInvocations={ delegateInvocations }");

            // Zapisanie wartości w pamięci podręcznej, tak by późniejsze wywołania Count 
            // nie skutkowały kolejnym uruchomieniem kwerendy.
            List<string> selectionCache = selection.ToList();

            Console.WriteLine(
                $"6. delegateInvocations={ delegateInvocations }");

            // Pobranie liczby elementów z kolekcji zapisanej w pamięci podręcznej.
            Console.WriteLine(
                $"7. selectionCache Count={ selectionCache.Count() }");

            Console.WriteLine(
                $"8. delegateInvocations={ delegateInvocations }");
        }
    }
}
