﻿// To pseudokod ilustrujący wygenerowany kod IL, dlatego jest niezgodny z zasadami
#pragma warning disable IDE0044 // Dodawanie modyfikatora readonly
#pragma warning disable IDE0060 // Usuwanie nieużywanego parametru
#pragma warning disable IDE1006 // Konwencje nazewnicze

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_18
{
    using System;

    public class Thermostat
    {
        // Eliminuje ostrzeżenie CS0469: pole nie ma przypisanej wartości i 
        // zawsze będzie miało wartość domyślną null.
        public Thermostat(EventHandler<TemperatureArgs>? onTemperatureChange)
        {
            _OnTemperatureChange = onTemperatureChange;
        }

        // ...
        // Deklarowanie pola typu delegata w celu 
        // zapisania listy subskrybentów.
        private EventHandler<TemperatureArgs>? _OnTemperatureChange;

        public void add_OnTemperatureChange(
            EventHandler<TemperatureArgs> handler)
        {
            System.Delegate.Combine(_OnTemperatureChange, handler);
        }

        public void remove_OnTemperatureChange(
            EventHandler<TemperatureArgs> handler)
        {
            System.Delegate.Remove(_OnTemperatureChange, handler);
        }

        //public event EventHandler<TemperatureArgs> OnTemperatureChange
        //{
        //    // Spowoduje błąd kompilacji
        //    add
        //    {
        //        add_OnTemperatureChange(value);
        //    }
        //    // Spowoduje błąd kompilacji
        //    remove
        //    {
        //        remove_OnTemperatureChange(value);
        //    }
        //}

        public class TemperatureArgs : System.EventArgs
        {
            public TemperatureArgs(float newTemperature)
            {
            }

        }
    }
}