﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter14.Listing14_15
{
    using System;

    public class Thermostat
    {
        public class TemperatureArgs : System.EventArgs
        {
            public TemperatureArgs(float newTemperature)
            {
                NewTemperature = newTemperature;
            }

            public float NewTemperature { get; set; }
        }

        // Definiowanie nadawcy zdarzeń.
        public event EventHandler<TemperatureArgs> OnTemperatureChange =
            delegate { };

        public float CurrentTemperature
        {
            get { return _CurrentTemperature; }
            set
            {
                if(value != CurrentTemperature)
                {
                    _CurrentTemperature = value;
                    // Jeśli istnieją subskrybenci,
                    // należy ich powiadomić o zmianie temperatury
                    // za pomocą skierowanego do nich wywołania.
                    OnTemperatureChange?.Invoke( // Składnia z wersji C# 6.0
                          this, new TemperatureArgs(value));
                }
            }
        }
        private float _CurrentTemperature;
    }
}