namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter12.Listing12_20
{
    using System;
    using Listing12_13;
// W rzeczywistem implementacji obiekt typu Item przechowywałby jakąś wartość
#pragma warning disable CS0168

    public class BinaryTree<T>
    {
        public BinaryTree(T item)
        {
            Item = item;
        }

        public T Item { get; set; }

        public Pair<BinaryTree<T>> SubItems
        {
            get { return _SubItems; }
            set
            {
                IComparable<T> first;
                // BŁĄD: nie można przeprowadzić niejawnej konwersji.
                // first = value.First; // Konieczne jest jawne rzutowanie.


                //if(first.CompareTo(value.Second) < 0)
                //{
                //    // Wartość właściwości First jest mniejsza niż właściwości Second.
                //    //...
                //}
                //else
                //{
                //    // Wartości właściwości First i Second są takie same
                //    // lub wartość właściwości Second jest mniejsza.
                //    //...
                //}
                _SubItems = value;
            }
        }
        private Pair<BinaryTree<T>> _SubItems;
    }
#pragma warning restore CS0168
}
