﻿using IntelliTect.TestTools.Console;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter10.Listing10_12.Tests
{
    [TestClass]
    public class TextNumberParserTests
    {
        [TestMethod]
        public void Main_HospitalEmergencyCodes_DisplaysCodes()
        {
            const string expected =
                @"info: Console[0]
      Kody triażu: = 'black', 'blue', 'brown', 'CBR', 'orange', 'purple', 'red', 'yellow'
warn: Console[0]
      To test kodów triażu...
";

            ConsoleAssert.Expect(expected, () => Program.Main(new[]
            {
                "black", "blue", "brown", "CBR",
                "orange", "purple", "red", "yellow"
            }));
        }
    }
}
